{* -*- Tab-Width:4; -*- *}
{[n+,u+,r+,d+,#+,j=13-/40/1o,t=2,o=95] PasMat formatting options}
{*                                                                       *}
{*                                                                       *}
{*                      RESTRICTED RIGHTS LEGEND                         *}
{*                                                                       *}
{* Use, duplication, or disclosure by the Government is subject to       *}
{* restrictions as set forth in subdivision (c)(1)(ii) of the Rights in  *}
{* Technical Data and Computer Software clause at 252.227-7013.          *}
{*                                                                       *}
{*                    TEXAS INSTRUMENTS INCORPORATED.                    *}
{*                            P.O. BOX 149149                            *}
{*                         AUSTIN, TEXAS 78714-9149                      *}
{*                              MS 2151                                  *}
{*                                                                       *}
{*  Copyright (C) 1987,1988,1989,1990 Texas Instruments Incorporated.    *}
{*  All rights reserved.                                                 *}
{*                                                                       *}

{------------------------------------------------------------------------------
FILE MakePFiles.p

NAME
  CreatePFile

DESCRIPTION
	General Tool to create, or modify the length of Load, Mcr, & Page files 
	with attention to contiguous allocation.

------------------------------------------------------------------------------}
UNIT MakePFiles;

INTERFACE

USES
	MemTypes, 
	Quickdraw, 
	OSIntf, ToolIntf, SCSIIntf, PackIntf,
    Signal,                            { to handle command-period}
    PasLibIntf,                        { for standard I/O, etc.}
	SANE;														{for string to num conversion }

	CONST
		BumpSize = 4;			{number of 1024 bytes blocks per i/o}
		ParmBlockSize = 1024;		{Bytes per blocks used in user interface.}

	 VAR		
		MyPBPtr:			ParmBlkPtr;			
		block: 				ParamBlockRec;
		FilenameParm:		Str255;
		vrefnum, bufsize: 	integer;
		LengthParm: 		longint;
		myerror:			integer;
	
    FUNCTION MakePFile(filename: str255; size: longint): longint;   
	
IMPLEMENTATION
	

{*-----------------------------------------------------------------*
 | Attempt to allocate LengthParm Bytes in the file pointed to by  |
 |  MyPBPtr.   Note MyParmPtr and Block must represent the         |
 |  Opened file. 	   											   |
 *----------------------------------------------------------------*}

FUNCTION AllocateSpace(NChunks: integer): Boolean;

	CONST
			async = false;
	VAR
			AllocCount, err: 	integer;
			temp, temp1: 		extended;
			BestAlloc,ltemp: 	Longint;

	BEGIN                         
		WITH block DO
			BEGIN
				AllocCount := NChunks;
				MyPBPtr := @block;
				temp1 := LengthParm * ParmBlockSize;
				temp := temp1 / NChunks;
				BestAlloc:=  Num2Longint(temp);
				{writeln('Allocate size=',bestalloc,' Nchunks=',alloccount);}
				REPEAT
					ioReqCount :=  BestAlloc;
					err := PBAllocContig(MyPBPtr, async);
					{IF err <> NoErr THEN writeln('Alloc Err=',err);}
					AllocCount := AllocCount - 1;
				UNTIL ((AllocCount = 0) OR (err <> 0));
			IF err = 0 THEN
				BEGIN
					ltemp := Num2Longint(temp1);
					ioMisc := ptr(ltemp);
					err := pbSetEof(MyPBPtr, async);
					IF err <> NoErr THEN
						BEGIN
							myerror := err;
							{writeln('pbSetEof Err=',err,' pos=',ltemp);}
						END
						ELSE
							AllocateSpace := TRUE;
				END
				ELSE
				BEGIN
					myerror := err;
					AllocateSpace := FALSE;
					{writeln('Alloc failed');}
				END
			END;		{with Block}
		END;             
		
FUNCTION AllSpace: boolean;
	CONST
			async = false;
	VAR
	  		result:			Boolean;
			NChunks:					integer;
			AllocCount, err, fullerrors: 	integer;
			temp, temp1, etemp: 			extended;
			bytesleft,thisalloc,ltemp,total: 	Longint;

    BEGIN      
		MyPBPtr := @block;
		result := true;
		fullerrors := 0;
		WITH block DO
			BEGIN
				AllocCount := 0;
				NChunks := 1;
				bytesleft := LengthParm * ParmBlockSize;
				total := bytesleft;
				thisalloc := total;		{go for broke}
				REPEAT
					ioReqCount :=  thisalloc;
					err := PBAllocContig(MyPBPtr, async);
					IF err = NoErr THEN 
						BEGIN
							AllocCount := AllocCount + 1;
							bytesleft := bytesleft - thisalloc;
						END
						ELSE
						BEGIN
							myerror := err;
							IF err = dskFulErr THEN 
							BEGIN
								fullerrors := fullerrors + 1;
								{writeln('PBAllocContig size=',thisalloc ,'  err=',err);} 
								thisalloc := thisalloc DIV 2;
							END
							ELSE
							BEGIN
								{writeln('Bytes not allocated = ',bytesleft);}
								result := FALSE;
								thisalloc := -1; {force exit}
							END
						END
				UNTIL ((bytesleft <= 0) OR (thisalloc < 2));
				if (err <> 0) THEN result := TRUE;
				ltemp := total - bytesleft;
				ioMisc := ptr(ltemp);
				if (ltemp > 0) THEN err := pbSetEof(MyPBPtr, async);
				IF err <> NoErr THEN
					BEGIN
						myerror := err;
						{writeln('pbSetEof Err=',err,' pos=',total)}
					END
					ELSE
					BEGIN
						{writeln('Alloc Set for ',total,' bytes.');}
						IF ((fullerrors > 0) AND (bytesleft <> 0)) THEN 
							myerror := dskFulErr  {remember disk full}
							ELSE myerror := alloccount;  {tell how many extents it took}
					END
			END;		{with Block}
			
			{writeln('Allspace = ',result,' myerr=',myerror);}
			allspace := result;
		END;             


FUNCTION SetLength: boolean;
	CONST
		async = false;
	VAR
	  	err:							integer;
		total:     						Longint;

    BEGIN      
		MyPBPtr := @block;
		setlength := FALSE;
		WITH block DO
			BEGIN
				Total := LengthParm * ParmBlockSize;
				ioMisc := ptr(total);
				err := pbSetEof(MyPBPtr, async);
				IF err <> NoErr THEN
					BEGIN
						myerror := err;
					END
				ELSE
					BEGIN
						setlength := TRUE;
					END
			END;		{with Block}
	END;             
	
{*-----------------------------------------------------------------*
 | Attempt to create the file, filename, and allocate size 1024    |
 | blocks.   If file already exists set the allocation anyway.     | 
 | Return value if positive is the number of extents it took.      |
 | If negative it represents an error.				   |
 *----------------------------------------------------------------*}

	
FUNCTION MakePFile(filename: str255; size: longint): longint;
	
	CONST
			version = 0;
			async = false;
			
    VAR
			complete: procptr;
			misc:  ptr;
			err: integer;
			nameptr,volptr: StringPtr;
			iorefnum, AllocCount:  integer;
			filetype:	OSType;
			BestAlloc, NChunks, left: Longint;
			temp: extended;
			done: Boolean;			

    BEGIN
			myerror := 0;
			filenameparm := filename;
			LengthParm := size;
			WITH block DO
				BEGIN
					nameptr := @filenameparm;
					ioNamePtr := nameptr;
					{ Use Exclusive read/write permission }
					ioPermssn := fsRdWrPerm;
					ioCompletion :=  NIL;  	{no completion routine ==> async, no initiate}
					ioVRefNum := vrefnum;
					ioVersNum := version;
					ioMisc := NIL;		{use volume buffer for access path's buffer}
					MyPBPtr := @block;
					err := PBOpen(MyPBPtr, async);			{probe file}
					IF err = 0 THEN
						BEGIN 
							done := setlength;
							err := PBClose(MyPBPtr, async);
						END
						ELSE
						BEGIN
				 			err := PBCreate(MyPBPtr, async); 
							IF ERR <> 0 THEN
								BEGIN
									myerror := err;
									{writeln('PBCreate complete, Err=',err);}
								END;
							err := PBOpen(MyPBPtr, async);
							IF ERR <> 0 THEN
								BEGIN
									myerror := err;
									{writeln('PBOpen complete, Err=',err);}
								end;
							Done := AllSpace;
							err := PBClose(MyPBPtr, async);
							IF ERR <> 0 THEN
								BEGIN
									myerror := err;
									{writeln('PBClose complete, Err=',err);}
								END;
							{IF DONE = FALSE THEN}
								{Writeln('Allocation Failed')}
						END;
			END;
			{writeln('myerror=',myerror);}
			makepfile := myerror;
			{writeln('MakeFile done');}
    END;

END.